/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIECONFIGSPACE_H
#define PCIECONFIGSPACE_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

class CAgtPCIEControl;

class CPCIEConfigSpace
{
public:

  // = FOUNDATION

  enum ConfigSpaceEntryOffsetDW
  {
    CONFIGSPACEENTRYOFFSET_DW_DEVICE_VENDOR_ID = 0x0,
    CONFIGSPACEENTRYOFFSET_DW_STATUS_COMMAND   = 0x1,
    CONFIGSPACEENTRYOFFSET_DW_NOFENTRIES
  };

  CPCIEConfigSpace( void );
  ~CPCIEConfigSpace( void );

  UInt32 ConfigSpaceDirectRead( const AgtPortHandleT& portHandle, UInt32 offset );
  void ConfigSpaceDirectWrite( const AgtPortHandleT& portHandle, UInt32 offset, UInt32 val );

private:

  CAgtPCIEControl* myController;

};

#endif /* PCIECONFIGSPACE_H */